﻿using System;
using System.Diagnostics;
using System.Drawing;

using System.Windows.Controls;
using System.Windows.Data;
using System.Windows;
using System.Collections.Generic;
using InputDevices;
using System.Windows.Interop;

using System.Windows.Media.Imaging;
using System.Runtime.InteropServices;
using System.Windows.Threading;

using System.ComponentModel;
using TwoCamWPF.Settings;
using TwoCamWPF.Helpers;
using TwoCamWPF.Settings.SettingsPage;
using System.Reflection;

namespace TwoCamWPF
{
    /// <summary>
    /// Логика взаимодействия для frmSettings.xaml
    /// </summary>
    public partial class frmSettings : Window, IDisposable
    {
       
        Settings.ClassSettings s;
        Dictionary<string, ISavedBasedViewModel> models = new Dictionary<string, ISavedBasedViewModel>();
        internal frmSettings(Settings.ClassSettings settings)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Открыто окно настроек");
            s = settings;
            InitializeComponent();

            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Установка настроек CameraSettingsModel");
            models.Add("CamerasSettings", new CameraSettingsModel(settings["CamerasSettings"] as CamerasSettings));
            camSettingsPage1.DataContext = models["CamerasSettings"];

            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Установка настроек StartSettingsPanel");
            models.Add("StartSettings",  new StartSettingsModel(settings["StartSettings"] as StartSettings));
            startSettingsPanel1.DataContext = models["StartSettings"];


            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Установка настроек АшдуSettingsPanel");
            fileSettingsPage1.DataContext = models["CamerasSettings"];

            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Установка настроек RecordSettingsPage");
            models.Add("RecordSettings", new RecordSettingsModel(settings["RecordSettings"] as RecordSettings));
            recordSettingsPage1.DataContext = models["RecordSettings"];


        
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
         
        }

        private void btnExit_Click(object sender, RoutedEventArgs e)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Нажата кнопка закрытия окна настроек");
          //  models.ForEach(p => p.Value.Dispose());
            Close();
        }

        private void btnSave_Click(object sender, RoutedEventArgs e)
        {
            Log.LogClass.Enqueue(MethodBase.GetCurrentMethod(), "Нажата кнопка сохранения настроек");
            s.Save();
            Close();
        }

        public void Dispose()
        {
            models.ForEach(p => p.Value.Dispose());
            models.Clear();
            GC.SuppressFinalize(this);
        }
    }
}
